﻿/*********************************************************************
Copyright 2003 © Victor Company of Japan, Limited All Right reserved.
The following JavaScript for the XML Service Manual includes our
patent-pending algorithm.
**********************************************************************/
/***********
** JVC SVG Viewerカスタマイズスクリプト
***********/
copyright = 'Copyright 2003-2006 © Victor Company of Japan, Limited All Rights reserved.';
patent = 'The XML Service Manual includes our patent-pending algorithm.';
svgFunction_js = '3.0.10';		// 2006.05.11 - I.NUNO

/************
**  テキスト定数
************/
var _s001 = 'JVC Menu';
var _s002 = 'undefined';
var _s0021 = 'to Basket...';
var _s0022 = 'Data Sheet';
var _s0023 = 'Centering';
var _s0024 = 'Unselect this';
var _s0025 = 'Change Color...';
//var _s0026 = 'Mark';
var _s003 = 'Print Screen...';
var _s004 = 'Get URL Information';
var _s005 = 'My Favorite Link';
var _s006 = 'Transparent View';
var _s007 = 'Comment View';
var _s008 = 'Reversed View';
var _s009 = 'Auto Zoom Out';
var _s010 = 'Layer View';
var _s0101 = 'All Layers';
var _s011 = 'Zoom In';
var _s012 = 'Zoom Out';
var _s013 = 'Original View';
var _s014 = 'Higher Quality';
var _s015 = 'Pause';
var _s016 = 'Mute';
var _s017 = 'Find Text...';
var _s018 = 'Find Text Again';
var _s019 = 'Copy Selected Text';
var _s020 = 'Copy SVG';
var _s021 = 'View SVG...';
var _s022 = 'View PDF...';
var _s023 = 'View Source...';
var _s024 = 'Save SVG As...';
var _s025 = 'About Drawing...';
var _s026 = 'Help...';
var _s027 = 'About Adobe SVG Viewer...';
var _a0251 = 'Manual No.' + '\t';
var _a0252 = 'Model No.' + '\t\t';
var _a0253 = 'Block No.' + '\t\t';
var _a0254 = 'Drawing Name' + '\t';
var _a0255 = 'Drawing Version' + '\t';
var _a0256 = 'Drawing Time Stamp' + '\t';
var _a0257 = 'Script Enable' + '\t';

function chgLang() {
	_s001 = 'JVCメニュー';
	_s002 = '未確定';
	_s0021 = 'バスケットへ...';
	_s0022 = 'データシート';
	_s0023 = 'センタリング';
	_s0024 = '選択解除';
	_s0025 = '色変更...';
//	_s0026 = 'マーク';
	_s003 = '画面印刷...';
	_s004 = 'URL情報を取得';
	_s005 = 'お気に入りリンク';
	_s006 = '透過表示';
	_s007 = 'コメント表示';
	_s008 = '反転表示';
	_s009 = '自動ズームアウト';
	_s010 = 'レイヤー表示';
	_s0101 = '全レイヤー表示';
	_s011 = 'ズームイン';
	_s012 = 'ズームアウト';
	_s013 = 'オリジナル表示';
	_s014 = '高画質';
	_s015 = '一時停止';
	_s016 = 'ミュート';
	_s017 = '検索...';
	_s018 = '次を検索';
	_s019 = '選択しているテキストをコピー';
	_s020 = 'SVGをコピー';
	_s021 = 'SVGを表示...';
	_s022 = 'PDFを表示...';
	_s023 = 'ソースを表示...';
	_s024 = 'SVGを別名で保存...';
	_s025 = '図面について...';
	_s026 = 'ヘルプ...';
	_s027 = 'Adobe SVG Viewerについて...';
	_a0251 = 'マニュアルNo.' + '\t';
	_a0252 = 'モデルNo.' + '\t\t';
	_a0253 = 'ブロックNo.' + '\t\t';
	_a0254 = '図面名' + '\t\t';
	_a0255 = '図面バージョン' + '\t';
	_a0256 = '図面更新日時' + '\t';
	_a0257 = 'スクリプト許可' + '\t';
}

/************
**  デフォルトコンテキスト設定
************/
function menuSet() {
	var context = '<menu>';
	context += '<header>Custom Menu</header>';
	context += '<item onactivate="aboutCopyrightInfo()" id="CustomMenu">' + _s001 + '</item>';
	context += '<separator/>';
	context += '<item enabled="no" id="PartsSelect">' + _s002 + '</item>';	// item(4);
	context += '<separator/>';
	// 印刷メニュー
	context += '<item onactivate="browserEval(\'window.print()\')" id="Print">' + _s003 + '</item>';
	context += '<item enabled="no" id="GetLocation">' + _s004 + '</item>';
	context += '<separator/>';
	// お気に入りメニュー
	context += '<item enabled="no" id="MyFavoriteLink">' + _s005 + '</item>';
	context += '<separator/>';
	// 透過モードメニュー
	context += '<item onactivate="changeOpacity()" id="TransparentView" checked="no">' + _s006 + '</item>';
	// コメント表示メニュー
	if (document.getElementById('z|annotation') == null) {
		context += '<item id="CommentView" enabled="no">' + _s007 + '</item>';
	} else {
		context += '<item onactivate="changeComment()" id="CommentView" checked="yes">' + _s007 + '</item>';
	}
	// 図面反転
	if (detPCB) {
		if (reversed == false) {
			context += '<item onactivate="reverse()" id="ReversedView" checked="no">' + _s008 + '</item>';
		} else {
			context += '<item onactivate="reverse()" id="ReversedView" checked="yes">' + _s008 + '</item>';
		}
	} else {
		context += '<item id="ReversedView" enabled="no">' + _s008 + '</item>';
	}
	// 自動ズームアウト
	context += '<item onactivate="changeAutoZoom()" id="AutoZoom" checked="yes">' + _s009 + '</item>';
	autoZoomOut = true;
	// レイヤーメニュー
	if (detPCB) {
		context += '<menu id="LayerSelection">';
			context += '<header>' + _s010 + '</header>';
			context += '<item onactivate="showAllLayers()" id="AllLayers" enabled="yes">' + _s0101 + '</item>';
			context += '<separator/>';
			if (reversed == false) {
				for (var i = centerLayerNum; i >= 0; i--) {
					context += '<item onactivate="changeLayer(\'' + allLayerG[i].id + '\')" id="' + allLayerG[i].id + '" checked="' + layerMenuChecked[allLayerG[i].id] +'">' + allLayerG[i].getAttribute(":name") + '</item>';
				}
			} else {
				for (var i = allLayerG.length - 1; i >= centerLayerNum; i--) {
					context += '<item onactivate="changeLayer(\'' + allLayerG[i].id + '\')" id="' + allLayerG[i].id + '" checked="' + layerMenuChecked[allLayerG[i].id] +'">' + allLayerG[i].getAttribute(":name") + '</item>';
				}
			}
		context += '</menu>';
	} else {
		context += '<item enabled="no" id="LayerSelection">' + _s010 + '</item>';
	}
	context += '<separator/>';
	context += '<item action="ZoomIn" id="ZoomIn">' + _s011 + '</item>';
	context += '<item action="ZoomOut" id="ZoomOut">' + _s012 + '</item>';
	context += '<item onactivate="showOriginalView()" id="OriginalView">' + _s013 + '</item>';
	context += '<separator/>';
	context += '<item action="Quality" id="Quality">' + _s014 + '</item>';
	context += '<item action="Pause" id="Pause">' + _s015 + '</item>';
	//context += '<item action="Mute" id="Mute">' + _s016 + '</item>';
	context += '<separator/>';
	context += '<item action="Find" id="Find" checked="no">' + _s017 + '</item>';
	context += '<item action="FindAgain" id="FindAgain">' + _s018 + '</item>';
	context += '<separator/>';
	context += '<item action="Copy" id="Copy">' + _s019 + '</item>';
	//context += '<item action="CopySVG" id="CopySVG">' + _s020 + '</item>';
	context += '<item action="ViewSVG" id="ViewSVG">' + _s021 + '</item>';
	//context += '<item action="ViewSource" id="ViewSource">' + _s023 + '</item>';
	if (getpdfInfo() != "") {
		context += '<item onactivate="viewPdf(getpdfInfo())" id="ViewPDF">' + _s022 + '</item>';
	}
	context += '<item action="SaveAs" id="SaveAs">' + _s024 + '</item>';
	context += '<separator/>';
	// 図面情報表示
	context += '<item onactivate="aboutDrawingInfo()">' + _s025 + '</item>';
	context += '<separator/>';
	context += '<item action="Help" id="Help">' + _s026 + '</item>';
	context += '<item action="About" id="About">' + _s027 + '</item>';
	context += '</menu>';
	
	//var newMenuRoot = parseXML(context, contextMenu);
	//contextMenu.replaceChild(newMenuRoot, contextMenu.firstChild);
	
	// Adobe SVG Viewer 6.0対応
	var ver = getSVGViewerVersion();
	if (ver.indexOf("Adobe") != -1) {
		var newMenuRoot = parseXML(context, contextMenu);
		if (ver.indexOf("6.0") != -1) {
			getContextMenu().replaceChild(newMenuRoot.firstChild,getContextMenu().firstChild);
		} else {
			getContextMenu().replaceChild(newMenuRoot,getContextMenu().firstChild);
		}
	}
}

/************
**  コンテキストメニューオプション対応
************/
function UpdateMenu(optionName, optionType, optionSubmenu, exclusive) {
	// exclusive: 同階層レベルのメニューを排他的に制御するか否か
	var optionValue;
	var eachItem;
	var eachSubItem;
	var on;
	var off;
	
	switch (optionType) {
		case 'checked':
		case 'enabled':
			on = 'yes';
			off = 'no';
			break;
		case 'display':
			on = 'inline';
			off = 'none';
			break;
	}
	
	var menuItems = contextMenu.childNodes.item(0).childNodes;
	
	for (i = 0; i < menuItems.length; i++) {
		if (1 == menuItems.item(i).nodeType) {
			eachItem = menuItems.item(i);
			if (null == optionSubmenu) {
				if (optionName == eachItem.getAttribute('id')) {
					targetItem = eachItem;
					if (null != optionType) {
						optionValue = targetItem.getAttribute(optionType);
					}
				}
			} else if ((eachItem.nodeName == 'menu') && (optionSubmenu == eachItem.getAttribute('id'))) {
				submenuItems = eachItem.childNodes;
				for (j = 0; j < submenuItems.length; j++) {
					eachSubItem = submenuItems.item(j)
					if (1 == eachSubItem.nodeType) {
						if (true == exclusive) {
							optionValue = off;
							if (null != optionType) {
								eachSubItem.setAttribute(optionType, off);
							}
						}
						if (optionName == eachSubItem.getAttribute('id')) {
							targetItem = eachSubItem;
							if (null != optionType) {
								optionValue = targetItem.getAttribute(optionType);
							}
						}
					}
				}
			}
		}
	} 
	if (on == optionValue) {
		if (null != optionType) {
			targetItem.setAttribute(optionType, off);
		}
	} else if (off == optionValue) {
		if (null != optionType) {
			targetItem.setAttribute(optionType, on);
		}
	}
}

/************
**  レイヤーメニュー更新
************/
function LayerMenuUpdate(enabledAll) {
	// レイヤーメニュー
	var context = '<menu id="LayerSelection">';
	context += '<header>' + _s010 + '</header>';
	context += '<item onactivate="showAllLayers()" id="AllLayers" enabled="' + enabledAll + '">' + _s0101 + '</item>';
	context += '<separator/>';
	if (reversed == false) {
		for (var i = centerLayerNum; i >= 0; i--) {
			context += '<item onactivate="changeLayer(\'' + allLayerG[i].id + '\')" id="' + allLayerG[i].id + '" checked="' + layerMenuChecked[allLayerG[i].id] +'">' + allLayerG[i].getAttribute(":name") + '</item>';
		}
	} else {
		for (var i = allLayerG.length - 1; i >= centerLayerNum; i--) {
			context += '<item onactivate="changeLayer(\'' + allLayerG[i].id + '\')" id="' + allLayerG[i].id + '" checked="' + layerMenuChecked[allLayerG[i].id] +'">' + allLayerG[i].getAttribute(":name") + '</item>';
		}
	}
	context += '</menu>';
	var appendMenu = parseXML(context, contextMenu);
	var menuRoot = contextMenu.firstChild;
	menuRoot.replaceChild(appendMenu, menuRoot.childNodes.item(14));
}

/************
**  図形非選択
************/
function cancelPart() {
	selectPlist('', '');
	cancel(selected);
	syncsvg('', '');
}

/************
**  図形クリック時イベント
************/
function click(evt) {
	var parts = getParts(evt.target);
	//if (selected != parts) {
	if ((selected != parts) && (parts.toLowerCase() != "unknown")) {
		//showTooltip(evt, parts);
		selectPlist(zinfo["z:blockid"], parts);
		select(parts, false);
		syncsvg(zinfo["z:blockid"], parts);
	} else {
		selectPlist(zinfo["z:blockid"], parts);
//		selectPlist('', '');
//		cancel(selected);
//		syncsvg('', '');
		syncsvg(zinfo["z:blockid"], parts);
	}
}

/************
**  図形マウスオーバー時イベント
************/
function mouseover(evt) {
	var g = evt.target.parentNode;
	while (!g.hasAttribute(':l') && !g.hasAttribute(':name')) {
		g = g.parentNode;
	}
	var parts = g.getAttribute(':l');
	parts = parts.split('|')[0];
	//if ((parts != null) && (parts != '')) {
	if ((parts != null) && (parts != '') && (parts.toLowerCase() != "unknown")) {
		//g.setAttribute('style', 'cursor:pointer');	// Adobe SVG Viewer 6.0のみ有効
		selectOver(parts);
		showTooltip(evt, parts);
	} else {
		cancelOver(selectedOver);
	}
}

/************
**  図形マウスアウト時イベント
************/
function mouseout(evt) {
	ttG.setAttribute("visibility", "hidden");
	cancelOver(selectedOver);
}

/************
**  ツールチップ表示
************/
function showTooltip(evt, txt) {
	var offsetX = 0;
	var offsetY = 0;
	var posx = evt.clientX;
	var posy = evt.clientY;
	ttText.childNodes.item(0).data = txt;
	var tx = svgG.currentTranslate.x;
	var ty = svgG.currentTranslate.y;
	var scale = svgG.currentScale;
	var unitPerPixel;
	var viewW = Number(viewBox[2]);
	var viewH = Number(viewBox[3]);
	
	if (viewW/viewH > innerWidth/innerHeight) {
		// windowが縦長
		unitPerPixel = viewW/innerWidth;
		offsetY = (innerHeight - (viewH/unitPerPixel))/2
	} else {
		// windowが横長
		unitPerPixel = viewH/innerHeight;
		offsetX = (innerWidth - (viewW/unitPerPixel))/2
	}
	var xx = (((posx-tx)/scale - offsetX) * unitPerPixel)  + Number(viewBox[0]) + (10*unitPerPixel/scale)
	var yy = (((posy-ty)/scale - offsetY) * unitPerPixel)  + Number(viewBox[1]) - (30*unitPerPixel/scale);
	// 影
	ttRectS.setAttribute("x", xx + (3 * unitPerPixel/scale));
	ttRectS.setAttribute("y", yy + (3 * unitPerPixel/scale));
	ttRectS.setAttribute("width", 100 * unitPerPixel/scale);
	ttRectS.setAttribute("height", 20 * unitPerPixel/scale);
	// チップボックス
	ttRect.setAttribute("x", xx);
	ttRect.setAttribute("y", yy);
	ttRect.setAttribute("width", 100 * unitPerPixel/scale);
	ttRect.setAttribute("height", 20 * unitPerPixel/scale);
	// チップテキスト
	ttText.setAttribute("x", xx + (8 * unitPerPixel/scale));
	ttText.setAttribute("y", yy + (16 * unitPerPixel/scale));
	ttText.setAttribute("font-size", 16 * unitPerPixel/scale);
	ttRect.setAttribute("stroke-width", 1 * unitPerPixel/scale);
	ttRect.setAttribute("width", ttText.getComputedTextLength() + (16 * unitPerPixel/scale));
	ttRectS.setAttribute("width", ttText.getComputedTextLength() + (16 * unitPerPixel/scale));
	ttG.setAttribute("visibility", "visible");
}

/************
**  パーツ色変更
************/
function changeColor(col) {
	var color;
	var cacheItem;
	if (selected != null) {
		cacheItem = cache[selected];
		for (color in cacheItem) {
			var g;
			g = cacheItem[color];
			if (g.hasAttribute('z:cf')) { 
				g.setAttribute('z:cf', col);
				g.setAttribute('fill', col);
			}
			if (g.hasAttribute('z:cs')) { 
				g.setAttribute('z:cs', col);
				g.setAttribute('stroke', col);
			}
			cancelPart();
		}
	}
}

/************
**  パーツ選択解除（クリック）
************/
function cancel(parts) {
	var color;
	var cacheItem;
	cacheItem = cache[parts];
	for (color in cacheItem) {
		var g;
		g = cacheItem[color];
		if (g.hasAttribute('z:cf')) {
			g.setAttribute('fill', g.getAttribute('z:cf'));
		}
		if (g.hasAttribute('z:cs')) {
			g.setAttribute('stroke', g.getAttribute('z:cs'));
		}
//		g.removeChild(g.firstChild);
	}
	// メニュー制御
	var context = '<item enabled="no" id="PartsSelect">' + _s002 + '</item>';
	var appendMenu = parseXML(context, contextMenu);
	var menuRoot = contextMenu.firstChild;
	menuRoot.replaceChild(appendMenu, menuRoot.childNodes.item(3));
	copyLocationMenuUpdate('', '', '', '');
	favoriteMenuUpdate('', '', '', '');
	removeCrossLine();
	selected = null;
}

/************
**  パーツ選択解除（マウスアウト）
************/
function cancelOver(parts) {
	var color;
	var cacheItem;
	cacheItem = cacheOver[parts];
	for (color in cacheItem) {
		var g;
		g = cacheItem[color];
		if (g.hasAttribute('z:cf')) { 
			if (selected == parts) {
				g.setAttribute('fill', 'red');
			} else {
				g.setAttribute('fill', g.getAttribute('z:cf'));
			}
		}
		if (g.hasAttribute('z:cs')) { 
			if (selected == parts) {
				g.setAttribute('stroke', 'red');
			} else {
				g.setAttribute('stroke', g.getAttribute('z:cs'));
			}
		}
	}
	selectedOver = null;
}

/************
**  パーツ選択（クリック：確定）
************/
function select(parts, setFocus) {
	if (zinfo["z:scriptenable"] != 1) {
		return;
	}
	cancel(selected);
	if (parts == null || parts == ''){
		return;
	}
	var rtn;
	var partsG, color, pid, cacheItem, bBox, partsBBox, minX, minY, maxW, maxH;
	var detSide;
	if (cache[parts] != null) {
		cacheItem = cache[parts];
		detSide = cacheSide[parts];
		rtn = cacheBBox[parts];
		for (color in cacheItem) {
			var g;
			g = cacheItem[color];
			if (g.hasAttribute('fill') && (g.getAttribute('fill') != 'none')) { 
				g.setAttribute('fill', 'red');
			}
			if (g.hasAttribute('stroke') && (g.getAttribute('stroke') != 'none')) { 
				g.setAttribute('stroke', 'red');
			}
//			g.insertBefore(animT.cloneNode(false), g.firstChild);
		}
	} else {
		var parts_piped = '|' + parts.toLowerCase() + '|';
		cacheItem = new Array();
		detSide = '';
		var pttrn = false;
		for (var i = centerLayerNum; i >= 0; i--) {
			if ((allLayerG[i].getAttribute(":name").toLowerCase().indexOf('outline') != -1) || (allLayerG[i].getAttribute(":name").toLowerCase().indexOf('surface') != -1)) {
				break;
			}
			if (allLayerG[i].getAttribute(":name").toLowerCase().indexOf('pattern') != -1) {
				pttrn = true;
			}
			partsG = allLayerG[i].firstChild;
			while (partsG != null) {
				if (partsG.nodeName == 'g') {
					pid = '|' + partsG.getAttribute(':l').toLowerCase() + '|' ;
					if (pid.indexOf(parts_piped) != -1) {
						detSide += allLayerG[i].getAttribute("side");
						color = partsG.firstChild;
						partsBBox = partsG.getBBox();
						if ((partsG.childNodes.length == 1) && (partsG.firstChild.nodeName != "circle")) {	// 一直線対応
							if ((partsG.firstChild.hasAttribute('d')) && (partsG.firstChild.getAttribute('d').indexOf('L') != -1)) {
								var d = partsG.firstChild.getAttribute('d').split('L');
								if (d.length <= 2) {
									minX = d[0].split(',')[0].match(/[0-9]+/);
									minY = d[0].split(',')[1].match(/[0-9]+/);
									maxW = d[1].split(',')[0].match(/[0-9]+/) - minX;
									maxH = d[1].split(',')[1].match(/[0-9]+/) - minY;
								}
							}
						}
						if (minX > partsBBox.x || minX == null) minX = partsBBox.x;
						if (minY > partsBBox.y || minY == null) minY = partsBBox.y;
						if (maxW < partsBBox.width || maxW == null) maxW = partsBBox.width;
						if (maxH < partsBBox.height || maxH == null) maxH = partsBBox.height;
						while (color != null) {
							if (color.hasAttribute('fill') && (color.getAttribute('fill') != 'none')) { 
								//if (detPCB) {	// 基板図の場合
								if (pttrn) {	// パターンの場合
									color.setAttribute('z:cf', color.getAttribute('fill'));
								}
								color.setAttribute('fill', 'red');
							}
							if (color.hasAttribute('stroke') && (color.getAttribute('stroke') != 'none')) { 
								//if (detPCB) {	// 基板図の場合
								if (pttrn) {	// パターンの場合
									color.setAttribute('z:cs', color.getAttribute('stroke'));
								}
								color.setAttribute('stroke', 'red');
							}
							cacheItem.push(color);
//							color.insertBefore(animT.cloneNode(false), color.firstChild);
							color = color.nextSibling;
						}
					}
				}
				partsG = partsG.nextSibling;
			}
		}
		var pttrn = false;
		if (centerLayerNum > 0) {
			for (var i = allLayerG.length - 1; i >= centerLayerNum; i--) {
				if ((allLayerG[i].getAttribute(":name").toLowerCase().indexOf('outline') != -1) || (allLayerG[i].getAttribute(":name").toLowerCase().indexOf('foil') != -1)) {
					break;
				}
				if (allLayerG[i].getAttribute(":name").toLowerCase().indexOf('pattern') != -1) {
					pttrn = true;
				}
				partsG = allLayerG[i].firstChild;
				while (partsG != null) {
					if (partsG.nodeName == 'g') {
						pid = '|' + partsG.getAttribute(':l').toLowerCase() + '|' ;
						if (pid.indexOf(parts_piped) != -1) {
							detSide += allLayerG[i].getAttribute("side");
							color = partsG.firstChild;
							partsBBox = partsG.getBBox();
							if ((partsG.childNodes.length == 1) && (partsG.firstChild.nodeName != "circle")) {	// 一直線対応
								if ((partsG.firstChild.hasAttribute('d')) && (partsG.firstChild.getAttribute('d').indexOf('L') != -1)) {
									var d = partsG.firstChild.getAttribute('d').split('L');
									if (d.length <= 2) {
										minX = d[0].split(',')[0].match(/[0-9]+/);
										minY = d[0].split(',')[1].match(/[0-9]+/);
										maxW = d[1].split(',')[0].match(/[0-9]+/) - minX;
										maxH = d[1].split(',')[1].match(/[0-9]+/) - minY;
									}
								}
							}
							if (minX > partsBBox.x || minX == null) minX = partsBBox.x;
							if (minY > partsBBox.y || minY == null) minY = partsBBox.y;
							if (maxW < partsBBox.width || maxW == null) maxW = partsBBox.width;
							if (maxH < partsBBox.height || maxH == null) maxH = partsBBox.height;
							while (color != null) {
								if (color.hasAttribute('fill') && (color.getAttribute('fill') != 'none')) { 
									//if (detPCB) {	// 基板図の場合
									if (pttrn) {	// パターンの場合
										color.setAttribute('z:cf', color.getAttribute('fill'));
									}
									color.setAttribute('fill', 'red');
								}
								if (color.hasAttribute('stroke') && (color.getAttribute('stroke') != 'none')) { 
									//if (detPCB) {	// 基板図の場合
									if (pttrn) {	// パターンの場合
										color.setAttribute('z:cs', color.getAttribute('stroke'));
									}
									color.setAttribute('stroke', 'red');
								}
								cacheItem.push(color);
//								color.insertBefore(animT.cloneNode(false), color.firstChild);
								color = color.nextSibling;
							}
						}
					}
					partsG = partsG.nextSibling;
				}
			}
		}
		cache[parts] = cacheItem;
		cacheSide[parts] = detSide;
		//bBox = svgG.createSVGRect;
		bBox = new Object()		// Firefox対応
		if (minX == null || minY == null || maxW == null || maxH == null) {
			bBox = null;
			//cacheBBox[parts] = null;
			//rtn = null;
		} else {
			bBox.x = minX;
			bBox.y = minY;
			bBox.width = maxW;
			bBox.height = maxH;
		}
		cacheBBox[parts] = bBox;
		rtn = bBox;
	}
	if (cacheItem.length > 0) {
		selected = parts;
		getPartInfo(parts);
	}
	if (setFocus) {
		focusBBox(rtn);
	}
	if (detPCB) {
		if (reversed == false) {
			if (detSide.indexOf('front') == -1) {
				reverse();
			}
		} else {
			if (detSide.indexOf('rear') == -1) {
				reverse();
			}
		}
	}
	return rtn;
}

/************
**  パーツ選択（マウスオーバー：未確定）
************/
function selectOver(parts) {
	if (zinfo["z:scriptenable"] != 1) {
		return;
	}
//	if (detPCB) {	// 基板図の場合は対象外とする
//		return;
//	}
	if (parts == null || parts == ''){
		return;
	}
	var presercolor = 'darkorange';
	var rtn;
	var partsG, color, pid, cacheItem, bBox, partsBBox, minX, minY, maxW, maxH;
	var detSide;
	if (cacheOver[parts] != null) {
		cacheItem = cacheOver[parts];
		detSide = cacheSideOver[parts];
		for (color in cacheItem) {
			var g;
			g = cacheItem[color];
			if (g.hasAttribute('fill') && (g.getAttribute('fill') != 'none')) { 
				g.setAttribute('fill', presercolor);
			}
			if (g.hasAttribute('stroke') && (g.getAttribute('stroke') != 'none')) { 
				g.setAttribute('stroke', presercolor);
			}
		}
	} else {
		var parts_piped = '|' + parts.toLowerCase() + '|';
		cacheItem = new Array();
		detSide = '';
		for (var i = centerLayerNum; i >= 0; i--) {
			if (allLayerG[i].getAttribute(":name").toLowerCase().indexOf('outline') != -1) {	// 外形は除外
				break;
			}
			if (allLayerG[i].getAttribute(":name").toLowerCase().indexOf('pattern') != -1) {	// パターンは除外
				break;
			}
			partsG = allLayerG[i].firstChild;
			while (partsG != null) {
				if (partsG.nodeName == 'g') {
					pid = '|' + partsG.getAttribute(':l').toLowerCase() + '|' ;
					if (pid.indexOf(parts_piped) != -1) {
						detSide += allLayerG[i].getAttribute("side");
						color = partsG.firstChild;
						while (color != null) {
							if (color.hasAttribute('fill') && (color.getAttribute('fill') != 'none')) { 
								color.setAttribute('z:cf', color.getAttribute('fill'));
								color.setAttribute('fill', presercolor);
							}
							if (color.hasAttribute('stroke') && (color.getAttribute('stroke') != 'none')) { 
								color.setAttribute('z:cs', color.getAttribute('stroke'));
								color.setAttribute('stroke', presercolor);
							}
							cacheItem.push(color);
							color = color.nextSibling;
						}
					}
				}
				partsG = partsG.nextSibling;
			}
		}
		if (detPCB) {
			for (var i = allLayerG.length - 1; i >= centerLayerNum; i--) {
				if (allLayerG[i].getAttribute(":name").toLowerCase().indexOf('outline') != -1) {	// 外形は除外
					break;
				}
				if (allLayerG[i].getAttribute(":name").toLowerCase().indexOf('pattern') != -1) {	// パターンは除外
					break;
				}
				partsG = allLayerG[i].firstChild;
				while (partsG != null) {
					if (partsG.nodeName == 'g') {
						pid = '|' + partsG.getAttribute(':l').toLowerCase() + '|' ;
						if (pid.indexOf(parts_piped) != -1) {
							detSide += allLayerG[i].getAttribute("side");
							color = partsG.firstChild;
							while (color != null) {
								if (color.hasAttribute('fill') && (color.getAttribute('fill') != 'none')) { 
									color.setAttribute('z:cf', color.getAttribute('fill'));
									color.setAttribute('fill', presercolor);
								}
								if (color.hasAttribute('stroke') && (color.getAttribute('stroke') != 'none')) { 
									color.setAttribute('z:cs', color.getAttribute('stroke'));
									color.setAttribute('stroke', presercolor);
								}
								cacheItem.push(color);
								color = color.nextSibling;
							}
						}
					}
					partsG = partsG.nextSibling;
				}
			}
		}
		cacheOver[parts] = cacheItem;
		cacheSideOver[parts] = detSide;
	}
	if (cacheItem.length > 0) {
		selectedOver = parts;
	}
}

/************
**  パーツ取得
************/
function getParts(elem) {
	var g = elem.parentNode;
	while (!g.hasAttribute(':l') && !g.hasAttribute(':name')) {
		g = g.parentNode;
	}
	var parts = g.getAttribute(':l');
	return parts.split('|')[0];
}

/************
**  部品情報取得
************/
function getPartInfo(ref) {
	var pblk = '';
	var pno = '';
	var pname = '';
	var psheet = '';
	var psheetcount = 0;
	pblk = new Array();
	pno = new Array();
	pname = new Array();
	psheet = new Array();
	if ((embeded) && (window.top)) {	// for IE
		var rtn = getXmlPartsDom(ref, zinfo['z:blockid']);
	} else {		// for Firefox or Stand alone
		var rtn = getPartsDom(ref, zinfo['z:blockid']);
	}
	pblk = rtn.pblk;
	pno = rtn.pno;
	pname = rtn.pname;
	psheet = rtn.psheet;
	partsMenuUpdate(ref, zinfo["z:blockid"], pno, psheet);
	copyLocationMenuUpdate(pblk, ref, pno, pname);
	favoriteMenuUpdate(pblk, ref, pno, pname);
}

function getPartsDom(ref, blk) {
	var rtn = new Object();
	rtn.pblk = '';
	rtn.pno = '';
	rtn.pname = '';
	rtn.psheet = '';
	rtn.pblk = new Array();
	rtn.pno = new Array();
	rtn.pname = new Array();
	rtn.psheet = new Array();
	var psheetcount = 0;
	if (xmlparts != null) {
		var nodelist = xmlparts.getElementsByTagName("ROW");
		if (nodelist != null) {
			for (var i = 0; i < nodelist.length; i++) {
	  		  	if ((nodelist.item(i).getAttribute("REF") == ref) && (blk == "" ? true: nodelist.item(i).getAttribute("BLK") == blk)) {
					if (nodelist.item(i).getAttribute("MDL").indexOf(modelid) != -1) {
						rtn.pblk.push(nodelist.item(i).getAttribute("BLK"));
						if (nodelist.item(i).getElementsByTagName("PART").item(0).hasChildNodes()) {
							rtn.pno.push(nodelist.item(i).getElementsByTagName("PART").item(0).firstChild.nodeValue);
						}
						if (nodelist.item(i).getElementsByTagName("NAME").item(0).hasChildNodes()) {
							rtn.pname.push(nodelist.item(i).getElementsByTagName("NAME").item(0).firstChild.nodeValue);
						}
						if (nodelist.item(i).getElementsByTagName("FILE3").item(0).hasChildNodes()) {
							rtn.psheet.push("true|" + nodelist.item(i).getElementsByTagName("FILE3").item(0).firstChild.nodeValue);
							psheetcount++;
						} else {
							rtn.psheet.push("false|");
						}
					}
				}
			}
			if (psheetcount == 0) {
				rtn.psheet = '';
			}
		}
	}
	return rtn;
}

/*************
**  お気に入りメニュー設定（SVGコンテキストメニュー）
**************/
function favoriteMenuUpdate(pblk, ref, pno, pname) {
	if (!window.top) {	// for Firefox
		var maxnode = 0;
		if (favorite != "") {
			maxnode = favorite.split("!").length - 1;
		}
		var s = favorite.split("!");
		var FVname = "";
		var FVsubname = "";
		var mdlflg = "";
		FVname = new Array();
		FVsubname = new Array();
		mdlflg = new Array();
		for (var i = 1; i <= maxnode; i++) {
			if (s[i - 1] != "") {
				FVname[i] = s[i - 1].split("@")[0];	// TITLE
				if (s[i - 1].split("@")[1] == "m") {
					mdlflg[i] = true;
					if (models.length > 1) {
						FVsubname[i] = new Array;
						for (var j = 0; j < models.length; j++) {
							FVsubname[i][j] = models[j];
						}
					} else {
						FVsubname[i] = models;
					}
				} else if (s[i - 1].split("@")[1] == "p") {
					mdlflg[i] = false;
					if (pno != '') {
						if (pno.length > 1) {
							FVsubname[i] = new Array;
							for (var j = 0; j < pno.length; j++) {
								FVsubname[i][j] = pno[j];
							}
						} else {
							FVsubname[i] = '';
						}
					} else {
						FVsubname[i] = '';
					}
				} else if (s[i - 1].split("@")[1] == "n") {
					mdlflg[i] = false;
					if (pname != '') {
						if (pno.length > 1) {
							FVsubname[i] = new Array;
							for (var j = 0; j < pname.length; j++) {
								FVsubname[i][j] = pname[j];
							}
						} else {
							FVsubname[i] = '';
						}
					} else {
						FVsubname[i] = '';
					}
				} else {
					mdlflg[i] = false;
					FVsubname[i] = '';
				}
			}
		}
	} else {
		// お気に入りリンク ----------------------
		var _FV				= "FV";
		var _FV_LINK		= "FV_LINK";
		var _FV_INFO		= "FV_INFO";
		var _ENABLE			= "EBABLE";
		var _NAME			= "NAME";
		var _URL			= "URL";
		var _METHOD			= "METHOD";
		var _SUBMIT			= "SUBMIT";
		var _ID				= "ID";
		var _PWD			= "PWD";
		var _FV_MAX 		= 10;
		// ---------------------------------------
		var maxnode = 0;
		var s;
		for (var i = 1; i <= _FV_MAX; i++) {
			s = _getCookie(_FV + i);
			if (s != "") {
				maxnode = i;
			} else {
				break;
			}
		}
		var FVname = "";
		var FVsubname = "";
		var mdlflg = "";
		FVname = new Array();
		FVsubname = new Array();
		mdlflg = new Array();
		for (var i = 1; i <= maxnode; i++) {
			s = _getCookie(_FV + i);
			if (s != "") {
				FVname[i] = s.split("|")[0];	// TITLE
				if (s.split("|")[3].indexOf('$(CurModel)') != -1) {
					mdlflg[i] = true;
					if (models.length > 1) {
						FVsubname[i] = new Array;
						for (var j = 0; j < models.length; j++) {
							FVsubname[i][j] = models[j];
						}
					} else {
						FVsubname[i] = models;
					}
				} else if (s.split("|")[3].indexOf('$(CurPartNo)') != -1) {
					mdlflg[i] = false;
					if (pno != '') {
						if (pno.length > 1) {
							FVsubname[i] = new Array;
							for (var j = 0; j < pno.length; j++) {
								FVsubname[i][j] = pno[j];
							}
						} else {
							FVsubname[i] = '';
						}
					} else {
						FVsubname[i] = '';
					}
				} else if (s.split("|")[3].indexOf('$(CurPartName)') != -1) {
					mdlflg[i] = false;
					if (pname != '') {
						if (pno.length > 1) {
							FVsubname[i] = new Array;
							for (var j = 0; j < pname.length; j++) {
								FVsubname[i][j] = pname[j];
							}
						} else {
							FVsubname[i] = '';
						}
					} else {
						FVsubname[i] = '';
					}
				} else {
					mdlflg[i] = false;
					FVsubname[i] = '';
				}
			}
		}
	}
	var context ='';
	if (maxnode == 0) {
		context += '<item enabled="no" id="MyFavoriteLink">' + _s005 + '</item>';
	} else {
		context += '<menu id="MyFavoriteLink">';
		context += '<header>' + _s005 + '</header>';
		for (var i = 1; i <= maxnode; i++) {
			if (FVname[i] != "") {
				if (FVsubname[i].length > 1) {
					context += '<menu id="MyFavoriteLinkSub">';
					context += '<header>' + FVname[i] + '</header>';
					for (var j = 0; j < FVsubname[i].length; j++) {
						if (mdlflg[i]) {
							if (pno.length > 1) {
								context += '<item onactivate="showFV(' + i + ',\'' + models[j] + '\',\'' + pblk[0] + '\',\'' + ref + '\',\'' + pno[0] + '\',\'' + pname[0] + '\')" id="Favorite' + i + '">' + FVsubname[i][j] + '</item>';
							} else {
								context += '<item onactivate="showFV(' + i + ',\'' + models[j] + '\',\'' + pblk + '\',\'' + ref + '\',\'' + pno + '\',\'' + pname + '\')" id="Favorite' + i + '">' + FVsubname[i][j] + '</item>';
							}
						} else {
							context += '<item onactivate="showFV(' + i + ',\'' + models[0] + '\',\'' + pblk[j] + '\',\'' + ref + '\',\'' + pno[j] + '\',\'' + pname[j] + '\')" id="Favorite' + i + '">' + FVsubname[i][j] + '</item>';
						}
					}
					context += '</menu>';
				} else {
					if (pno.length > 1) {
						context += '<item onactivate="showFV(' + i + ',\'' + models[0] + '\',\'' + pblk[0] + '\',\'' + ref + '\',\'' + pno[0] + '\',\'' + pname[0] + '\')" id="Favorite' + i + '">' + FVname[i] + '</item>';
					} else {
						context += '<item onactivate="showFV(' + i + ',\'' + models[0] + '\',\'' + pblk + '\',\'' + ref + '\',\'' + pno + '\',\'' + pname + '\')" id="Favorite' + i + '">' + FVname[i] + '</item>';
					}
				}
			}
		}
		context += '</menu>';
	}
	var appendMenu = parseXML(context, contextMenu);
	var menuRoot = contextMenu.firstChild;
	menuRoot.replaceChild(appendMenu, menuRoot.childNodes.item(8));
}

/************
**  クッキー読出し
************/
function _getCookie(sName) {
	var cookieArray = self.document.cookie.split('; ');
	for (var i = 0; i < cookieArray.length; i++) {
		var aCrumb = cookieArray[i].split('=')
		if ((sName == aCrumb[0]) && (aCrumb[1] != null)) {
			return unescape(aCrumb[1])
		}
	}
	return '';
}

/************
**  お気に入りメニュー表示
************/
function showFV(num, mdl, pblk, ref, pno, pname) {
	var mnl = xmlparts.getElementsByTagName("PARTSLIST").item(0).getAttribute("MNLNO");
	pname = escape(pname);	// Firefoxの場合、2バイト（日本語は引数とできない？対応）
	browserEval("showFVwin('" + num + "','" + mnl + "','" + mdl + "','" + pblk + "','" + ref + "','" + pno + "','" + pname + "');");
}

/************
**  部品選択時URL情報コピーメニュー更新
************/
function copyLocationMenuUpdate(blk, ref, pno, pname) {
	if (ref == '') {
		blk = zinfo["z:blockid"];
	}
	var bname = zinfo["z:drawingtitle"];
	var context ='';
	if (pno.length <= 1) {
		context += '<item onactivate="getLocation(\'' + bname + '\',\'' + blk + '\',\'' + ref + '\',\'' + pno + '\',\'' + pname + '\')" id="GetLocation">' + _s004 + '</item>';
	} else {
		context += '<menu id="getLocation">';
		context += '<header>' + _s004 + '</header>';
		for (var i = 0; i < pno.length; i++) {
			context += '<item onactivate="getLocation(\'' + bname + '\',\'' + blk[i] + '\',\'' + ref + '\',\'' + pno[i] + '\',\'' + pname[i] + '\')" id="GetLocation' + i + '">' + pno[i] + '</item>';
		}
		context += '</menu>';
	}
	var appendMenu = parseXML(context, contextMenu);
	var menuRoot = contextMenu.firstChild;
	menuRoot.replaceChild(appendMenu, menuRoot.childNodes.item(6));
}

/************
**  部品選択時コンテキストメニュー更新
************/
function partsMenuUpdate(ref, bno, pno, psheet) {
	var context = '<menu id="PartsSelect">';
	context += '<header>' + ref + '</header>';
//	if (pno.length > 1) {
//		context += '<menu id="OrderThis">';
//		context += '<header>' + _s0021 + '</header>';
//		for (var i = 0; i < pno.length; i++) {
//			context += '<item onactivate="showPoWin(\''+bno+'\',\''+ref+'\',\''+pno[i]+'\')">' + pno[i] + '</item>';
//		}
//		context += '</menu>';
//	} else {
//		if (pno != '') {
//			context += '<item onactivate="showPoWin(\''+bno+'\',\''+ref+'\',\''+pno[0]+'\')">' + _s0021 + '</item>';
//		} else {
//			context += '<item enabled="no">' + _s0021 + '</item>';
//		}
//	}
	if (psheet.length > 1) {
		context += '<menu id="DataSheet">';
		context += '<header>' + _s0022 + '</header>';
		for (var i = 0; i < psheet.length; i++) {
			if (psheet[i].split('|')[0] == 'true') {
				context += '<item onactivate="showDataWin(\''+psheet[i].split('|')[1]+'\')">' + pno[i] + '</item>';
			} else {
				context += '<item enabled="no">' + pno[i] + '</item>';
			}
		}
		context += '</menu>';
	} else {
		if (psheet != '') {
			if (psheet[0].split('|')[0] == 'true') {
				context += '<item onactivate="showDataWin(\''+psheet[0].split('|')[1]+'\')">' + _s0022 + '</item>';
			} else {
				context += '<item enabled="no">' + _s0022 + '</item>';
			}
		} else {
			context += '<item enabled="no">' + _s0022 + '</item>';
		}
	}
	context += '<separator/>';
//	context += '<item onactivate="focusBBox(select(\''+ref+'\'))">' + _s0023 + '</item>';
	context += '<item onactivate="select(\''+ref+'\', true)">' + _s0023 + '</item>';
	context += '<item onactivate="cancelPart()">' + _s0024 + '</item>';
//	context += '<separator/>';
//	context += '<menu id="ColorChange">';
//	context += '<header>' + _s0025 + '</header>';
//		context += '<item onactivate="changeColor(\'Red\')">Red</item>';
//		context += '<item onactivate="changeColor(\'Yellow\')">Yellow</item>';
//		context += '<item onactivate="changeColor(\'Lime\')">Lime</item>';
//		context += '<item onactivate="changeColor(\'Aqua\')">Aqua</item>';
//		context += '<item onactivate="changeColor(\'Blue\')">Blue</item>';
//		context += '<item onactivate="changeColor(\'Fuchsia\')">Fuchsia</item>';
//		context += '<item onactivate="changeColor(\'Maroon\')">Maroon</item>';
//		context += '<item onactivate="changeColor(\'Olive\')">Olive</item>';
//		context += '<item onactivate="changeColor(\'Green\')">Green</item>';
//		context += '<item onactivate="changeColor(\'Teal\')">Teal</item>';
//		context += '<item onactivate="changeColor(\'Navy\')">Navy</item>';
//		context += '<item onactivate="changeColor(\'Purple\')">Purple</item>';
//		context += '<item onactivate="changeColor(\'Black\')">Black</item>';
//	context += '</menu>';
//	context += '<separator/>';
//	context += '<item onactivate="setMark(\''+ref+'\',\''+bno+'\')">' + _s0026 + '</item>';
	context += '</menu>';
	var appendMenu = parseXML(context, contextMenu);
	var menuRoot = contextMenu.firstChild;
	menuRoot.replaceChild(appendMenu, menuRoot.childNodes.item(3));
}

/************
** 発注ウィンドウ表示
************/
function showPoWin(bno, ref, pno) {
	if (embeded) {
		browserEval("poder('" + bno + "','" + ref + "','" + pno + "')");
	}
}

/************
** データシートウィンドウ表示
************/
function showDataWin(fname){
	browserEval("window.open('ic/" + fname + ".xml', '', 'scrollbars=yes,resizable=yes,menubar=yes,directories=no,status=no,location=no,width=640,height=480', '_blank')");
}

/************
**  透過モード切替
************/
function changeOpacity() {
	if (rootG.getAttribute('fill-opacity') != '0.5') {
		rootG.setAttribute('fill-opacity', '0.5');
	} else {
		rootG.setAttribute('fill-opacity', '1');
	}
	UpdateMenu('TransparentView', 'checked', null, false);
}

/************
**  コメント表示切替
************/
function changeComment() {
	if (document.getElementById('z|annotation').getAttribute('visibility') == 'hidden') {
		document.getElementById('z|annotation').setAttribute('visibility', 'visible');
	} else {
		document.getElementById('z|annotation').setAttribute('visibility', 'hidden');
	}
	UpdateMenu('CommentView', 'checked', null, false);
}

/************
**  図面逆転
************/
function reverse() {
	// 図面反転
	if (rootG.hasAttribute('transform')) {
		// X軸逆転解除
		rootG.removeAttribute('transform');
		// Layerの順序を逆にする
//		for (var i = 1; i < allLayerG.length; i++) {
//		  rootG.appendChild(rootG.removeChild(allLayerG[i]));
//		}
	} else {
		// X軸逆転
		rootG.setAttribute('transform', 'matrix(-1 0 0 1 0 0)');
		// Layerの順序を逆にする
//		for (var i = allLayerG.length - 2; i >= 0; i--) {
//		  rootG.appendChild(rootG.removeChild(allLayerG[i]));
//		}
	}
	
	if (reversed == false) {
		for (var i = 0; i <= centerLayerNum; i++) {
			allLayerG[i].setAttribute('visibility', 'hidden');
			layerMenuChecked[allLayerG[i].id] = "no";
		}
		for (var i = centerLayerNum; i < allLayerG.length; i++) {
			if (allLayerG[i].getAttribute('side') == 'rear') {
				allLayerG[i].setAttribute('visibility', 'visible');
				layerMenuChecked[allLayerG[i].id] = "yes";
			}
		}
	} else {
		for (var i = 0; i <= centerLayerNum; i++) {
			if (allLayerG[i].getAttribute('side') == 'front') {
				allLayerG[i].setAttribute('visibility', 'visible');
				layerMenuChecked[allLayerG[i].id] = "yes";
			}
		}
		for (var i = centerLayerNum + 1; i < allLayerG.length; i++) {
			allLayerG[i].setAttribute('visibility', 'hidden');
			layerMenuChecked[allLayerG[i].id] = "no";
		}
	}
	reversed = !reversed;
//	allLayerChecked = false;
	allLayerChecked = true;
	LayerMenuUpdate('yes');
	
	// 十字線反転
	if (crosslineG != null) {
		if (crosslineG.hasAttribute('transform')) {
			// X軸逆転解除
			crosslineG.setAttribute('transform', 'matrix(1 0 0 -1 0 0)');
			crosslineG.removeAttribute('transform');
		} else {
			// X軸逆転
			crosslineG.setAttribute('transform', 'matrix(-1 0 0 1 0 0)');
		}
	}
	
	// コメント反転
	var commentG = document.getElementById('z|annotation');
	if (commentG != null) {
		var elem = commentG.firstChild;
		var elem2;
		if (commentG.hasAttribute('transform')) {
			// 反転解除
			commentG.removeAttribute('transform');
			while (elem != null) {
				if (elem.nodeName == 'text') {
					elem.removeAttribute('transform');
				} else if (elem.nodeName == 'g') {
					elem2 = elem.firstChild.nextSibling;  // landmark<text>狙い撃ち
					elem2.removeAttribute('transform');
				}
				elem = elem.nextSibling;
			}
		} else {
			// 反転(textは反転せず移動のみ)
			commentG.setAttribute('transform', 'matrix(-1 0 0 1 0 0)');
			while (elem != null) {
				if (elem.nodeName == 'text') {
					elem.setAttribute('transform', 'matrix(-1 0 0 1 ' + (elem.getBBox().x*2 + elem.getBBox().width) + ' 0)');
				} else if (elem.nodeName == 'g') {
					elem2 = elem.firstChild.nextSibling; // landmark<text>狙い撃ち
					elem2.setAttribute('transform', 'matrix(-1 0 0 1 ' + (elem2.getBBox().x*2 + elem2.getBBox().width) + ' 0)');
				}
				elem = elem.nextSibling;
			}
		}
	}
	// 安全指定部品反転
	var commentG = document.getElementById('z|safty');
	if (commentG != null) {
		var elem = commentG.firstChild;
		var elem2;
		if (commentG.hasAttribute('transform')) {
			// 反転解除
			commentG.removeAttribute('transform');
			while (elem != null) {
				elem.removeAttribute('transform');
				elem = elem.nextSibling;
			}
		} else {
			commentG.setAttribute('transform', 'matrix(-1 0 0 1 0 0)');
			while (elem != null) {
				elem.setAttribute('transform', 'matrix(-1 0 0 1 ' + (elem.getBBox().x*2 + elem.getBBox().width) + ' 0)');
				elem = elem.nextSibling;
			}
		}
	}
	showOriginalView();
	UpdateMenu('ReversedView', 'checked', null, false);
}

/************
**  自動ズームアウト切替
************/
function changeAutoZoom() {
	autoZoomOut = !autoZoomOut;
	UpdateMenu('AutoZoom', 'checked', null, false);
}

/************
**  全レイヤー表示
************/
function showAllLayers() {
	if (reversed) {
		for (var i = 0; i < centerLayerNum; i++) {
			allLayerG[i].setAttribute('visibility', 'hidden');
			layerMenuChecked[allLayerG[i].id] = "no";
		}
		for (var i = centerLayerNum; i < allLayerG.length; i++) {
			allLayerG[i].setAttribute('visibility', 'visible');
			layerMenuChecked[allLayerG[i].id] = "yes";
		}
	} else {
		for (var i = 0; i <= centerLayerNum; i++) {
			allLayerG[i].setAttribute('visibility', 'visible');
			layerMenuChecked[allLayerG[i].id] = "yes";
		}
		for (var i = centerLayerNum + 1; i < allLayerG.length; i++) {
			allLayerG[i].setAttribute('visibility', 'hidden');
			layerMenuChecked[allLayerG[i].id] = "no";
		}
	}
	allLayerChecked = true;
//	LayerMenuUpdate('no');
	LayerMenuUpdate('yes');
}

/************
**  レイヤー表示切替
************/
function changeLayer(id) {
//	var j = 1;
//	if (allLayerChecked == true) {
//		for (i in layerMenuChecked) {
//			if (layerMenuChecked[i] == 'yes') {
//				j++;
//			}
//		}
//	}
	if (layerMenuChecked[id] == 'yes') {
		layerMenuChecked[id] = 'no';
		document.getElementById(id).setAttribute('visibility', 'hidden');
//		if (allLayerChecked == false) {
//			allLayerChecked = !allLayerChecked;
//			UpdateMenu('AllLayers', 'enabled', 'LayerSelection', false);
//		}
	} else {
		layerMenuChecked[id] = 'yes';
		document.getElementById(id).setAttribute('visibility', 'visible');
//		if (j == allLayerG.length) {
//			allLayerChecked = !allLayerChecked;
//			UpdateMenu('AllLayers', 'enabled', 'LayerSelection', false);
//		}
	}
	UpdateMenu(id, 'checked', 'LayerSelection', false);
}


/************
**  著作権、バージョン情報表示
************/
function aboutCopyrightInfo() {
	var info = '';
	info += copyright + '\n';
	info += patent + '\n\n';
	info += 'Ver.' + svgFunction_js;
	alert(info);
}

/************
**  ロケーション情報をクリップボードへコピーオリジナル表示
************/
function getLocation(bname, blk, ref, pno, pname) {
	var mdl = models;
	var mnl = xmlparts.getElementsByTagName("PARTSLIST").item(0).getAttribute("MNLNO");
	bname = escape(bname);	// Firefoxの場合、2バイト（日本語は引数とできない？対応）
	pname = escape(pname);	// Firefoxの場合、2バイト（日本語は引数とできない？対応）
	if (embeded) {
		browserEval("getLocation2('" + mdl + "','" + mnl + "','" + bname + "','" + blk + "','" + ref + "','" + pno + "','" + pname + "','" + selfsvg + "','" + modelid + "')");
	}
}

/************
**  オリジナル表示
************/
function showOriginalView() {
	svgG.currentScale = 1;
	svgG.currentTranslate.y = 0;
	if (rootG.getCTM().a >= 0) {
		svgG.currentTranslate.x = 0;
	} else {
		var unitPerPixel, viewMidX;
		viewMidX = Number(viewBox[0]) + Number(viewBox[2]/2);
		if (viewBox[2]/viewBox[3] > innerWidth/innerHeight) {
			// windowが縦長
			unitPerPixel = viewBox[2]/innerWidth;
		} else {
			// windowが横長
			unitPerPixel = viewBox[3]/innerHeight;
		}
		svgG.currentTranslate.x = viewMidX*2/unitPerPixel;
	}
}

/************
**  BBoxをフォーカス
************/
function focusBBox(bBox) {
	if (zinfo["z:scriptenable"] != 1) {
		return;
	}
	var unitPerPixel, orgX, orgY, transX, transY, scale;
	var x, y, r, width, height, halfW, halfH;
	
	if ((bBox == null) || (selected == null)) {
		return;
	}
	y = Number(bBox.y);
	width = Number(bBox.width);
	height = Number(bBox.height);
	r = Math.sqrt(Math.pow(width,2) + Math.pow(height,2))/2;
	
	if (rootG.getCTM().a >= 0) {
		// 通常時
		x = Number(bBox.x);
		setCrossLine(x + width/2, y + height/2, r);
	} else {
		// 反転時
		x = Number(-bBox.x) - Number(bBox.width);
		setCrossLine(-x - width/2, y + height/2, r);
	}
	
	// translateが0,0になる点の論理座標を取得
	if (viewBox[2]/viewBox[3] > innerWidth/innerHeight) {
		// windowが縦長
		unitPerPixel = viewBox[2]/innerWidth;
		orgX = viewBox[0];
		orgY = (Number(viewBox[1]) + Number(viewBox[3])/2) - innerHeight/2 * unitPerPixel;
	} else {
		// windowが横長
		unitPerPixel = viewBox[3]/innerHeight;
		orgX = (Number(viewBox[0]) + Number(viewBox[2])/2) - innerWidth/2 * unitPerPixel;
		orgY = viewBox[1];
	}
	// BBoxに合わせてfocus移動
	scale = svgG.currentScale;
//	if (width/height > innerWidth/innerHeight) {
//		scale = unitPerPixel/width * innerWidth;
//	} else {
//		scale = unitPerPixel/height * innerHeight;
//	}
	if (autoZoomOut == true) {
		if (innerWidth/scale * unitPerPixel < width) {
			scale = scale * innerWidth/scale * unitPerPixel/width/2;
		} 
		if (innerHeight/scale * unitPerPixel < height) {
			scale = scale * innerHeight/scale * unitPerPixel/height/2;
		}
	}
	
//	if (scale > 32) scale = 32; // scaleがでかすぎるとSVGViewerがバグる
	transX = (orgX - ((x + width/2) - innerWidth/scale/2 * unitPerPixel))/unitPerPixel * scale;
	transY = (orgY - ((y + height/2) - innerHeight/scale/2 * unitPerPixel))/unitPerPixel * scale;
	
	if (Math.abs(transX) > 14000) { // translateの値がでかすぎるとSVGViewerがバグる
//		scale = scale * (14000/Math.abs(transX));
		transX = (orgX - ((x + width/2) - innerWidth/scale/2 * unitPerPixel))/unitPerPixel * scale;
		transY = (orgY - ((y + height/2) - innerHeight/scale/2 * unitPerPixel))/unitPerPixel * scale;
	}
	if (Math.abs(transY) > 14000){
//		scale = scale * (14000/Math.abs(transY));
		transX = (orgX - ((x + width/2) - innerWidth/scale/2 * unitPerPixel))/unitPerPixel * scale;
		transY = (orgY - ((y + height/2) - innerHeight/scale/2 * unitPerPixel))/unitPerPixel * scale;
	}
	svgG.currentScale = scale;
	svgG.currentTranslate.x = transX;
	svgG.currentTranslate.y = transY;
}

/************
**  ツールチップを生成
************/
function makeToolTip() {
	if (zinfo["z:scriptenable"] != 1) {
		return;
	}
	if (ttG != null) {
		var viewW = Number(viewBox[2]);
		var viewH = Number(viewBox[3]);
		if (viewW/viewH > innerWidth/innerHeight) {
			// windowが縦長
			unitPerPixel = viewW/innerWidth;
		} else {
			// windowが横長
			unitPerPixel = viewH/innerHeight;
		}
		ttG.setAttribute('id', 'tt');
		ttG.setAttribute('transform', 'scale(1)');
		ttG.setAttribute('visibility', 'hidden');
		// 影
		ttRectS.setAttribute('id', 'ttrs');
		ttRectS.setAttribute('x', '0');
		ttRectS.setAttribute('y', '0');
		//ttRectS.setAttribute('rx', 4 * unitPerPixel);
		//ttRectS.setAttribute('ry', 4 * unitPerPixel);
		ttRectS.setAttribute('width', 100 * unitPerPixel);
		ttRectS.setAttribute('height', 20 * unitPerPixel);
		ttRectS.setAttribute('fill', 'black');
		//ttRectS.setAttribute('stroke', 'black');
		ttRectS.setAttribute('stroke-width', 1 * unitPerPixel);
		ttRectS.setAttribute('fill-opacity', '0.25');
		ttRect.setAttribute('id', 'ttr');
		// チップボックス
		ttRect.setAttribute('x', '0');
		ttRect.setAttribute('y', '0');
		//ttRect.setAttribute('rx', 4 * unitPerPixel);
		//ttRect.setAttribute('ry', 4 * unitPerPixel);
		ttRect.setAttribute('width', 100 * unitPerPixel);
		ttRect.setAttribute('height', 20 * unitPerPixel);
		ttRect.setAttribute('fill', 'yellow');
		ttRect.setAttribute('stroke', 'silver');
		ttRect.setAttribute('stroke-width', 1 * unitPerPixel);
		ttRect.setAttribute('fill-opacity', '1');
		// チップテキスト
		ttText.setAttribute('id', 'ttt');
		ttText.setAttribute('x', '0');
		ttText.setAttribute('y', '0');
		ttText.setAttribute('fill', 'darkorange');
		ttText.setAttribute('font-size', 16 * unitPerPixel);
		ttText.setAttribute('font-weight', 'bold');
		ttText.appendChild(ttTextNode);
		ttG.appendChild(ttRectS);
		ttG.appendChild(ttRect);
		ttG.appendChild(ttText);
		svgG.appendChild(ttG);
	}
}

/************
**  十字線を生成
************/
function makeCrossLine() {
	if (zinfo["z:scriptenable"] != 1) {
		return;
	}
	if (crosslineG != null) {
		crosslineG.setAttribute('id', 'z|crossline');
		crosslineG.setAttribute('visibility', 'hidden');
		crosslineG.setAttribute('fill', 'none');
		crosslineG.setAttribute('stroke', 'red');
		crosslineG.setAttribute('stroke-width', '1');
//		crosslineG.setAttribute('fill-opacity', '0.5');
		crosslinePath.setAttribute('d', '');
		crosslineCircle.setAttribute('r', 0);
		crosslineCircle.setAttribute('cx', 0);
		crosslineCircle.setAttribute('cy', 0);
		crosslineG.appendChild(crosslinePath);
		crosslineG.appendChild(crosslineCircle);
//		crosslineG.insertBefore(animT.cloneNode(false), crosslineG.firstChild);
		svgG.appendChild(crosslineG);
	}
}

/************
**  十字線を表示
************/
function setCrossLine(x, y, r) {
	if (crosslineG != null) {
		removeCrossLine();
		crosslinePath.setAttribute('d', 'M-10000000000,'+y+',L20000000000,'+y+'M'+x+',-10000000000,L'+x+',20000000000');
//		crosslinePath.setAttribute('d', 'M'+viewBox[0]+','+y+',L'+viewBox[2]+','+y+'M'+x+','+viewBox[1]+',L'+x+','+viewBox[3]+'');
		crosslineCircle.setAttribute('r', r);
		crosslineCircle.setAttribute('cx', x);
		crosslineCircle.setAttribute('cy', y);
		crosslineG.setAttribute('visibility', 'visible');
	}
}

/************
**  十字線を非表示
************/
function removeCrossLine() {
	if (crosslineG != null) {
		if (crosslineG.getAttribute('visibility') == 'visible') {
			crosslineG.setAttribute('visibility', 'hidden');
		}
	}
}

/************
**  クローンレイヤー初期設定
************/
function setLayerClone() {
	if (zinfo["z:scriptenable"] != 1) {
		return;
	}
	var layerG = rootG.firstChild;
	var temp;
	var side = new Array();
	side[false] = "front";
	side[true] = "rear";
	var flg = true;
	while (layerG != null) {
		if (layerG.nodeName == 'g') {
//			layerMenuChecked[layerG.id] = "yes";
			if ((layerG.getAttribute(":name").toLowerCase().indexOf('outline') != -1) || (layerG.getAttribute(":name").toLowerCase().indexOf('foil') != -1)) {
				if (flg == true) {
					flg = !flg;
				}
			}
			if (flg == false) {
				layerMenuChecked[layerG.id] = "yes";
			} else {
				layerMenuChecked[layerG.id] = "no";
				layerG.setAttribute('visibility', 'hidden');
			}
			layerG.setAttribute('side', side[flg]);
			allLayerG.push(layerG);
		}
		layerG = layerG.nextSibling;
	}
	if (((zinfo["z:blockid"].substr(0, 1)).toUpperCase() == "M") || (zinfo["z:blockid"] == "") || (allLayerG.length == 1)) {
		detPCB = false;		// 配線図の場合、機構図・ブロック図で複数レイヤーの場合
	} else {
		detPCB = true;
	}
	centerLayerNum = allLayerG.length - 1;
	if (detPCB) {
		for (var i = centerLayerNum - 1; i >= 0; i--) {
			temp = allLayerG[i].cloneNode(true);		// 表示させるためには'true'
			temp.setAttribute('id', "-" + temp.getAttribute('id'));
			temp.setAttribute('visibility', 'hidden');
			rootG.appendChild(temp);
			layerMenuChecked[temp.id] = "no";
			if ((temp.getAttribute(":name").toLowerCase().indexOf('outline') != -1) || (temp.getAttribute(":name").toLowerCase().indexOf('surface') != -1)) {
				if (flg == false) {
					flg = !flg;
				}
			}
			temp.setAttribute('side', side[flg]);
			allLayerG.push(temp);
		}
	} else {		// 基板図以外の場合
		if (allLayerG.length > 0) {		// 機構図、ブロック図で複数レイヤーの場合
			for (var i = 0; i < allLayerG.length; i++) {
				allLayerG[i].setAttribute('visibility', 'visible');
			}
		} else {
			allLayerG[0].setAttribute('visibility', 'visible');
			layerMenuChecked[allLayerG[0].id] = "yes";
		}
	}
}

/************
**  ランドマーク対応
************/
function landmark(file){
	if (embeded) {
		browserEval("landmark2('" + file + "')");
	} else {
		browserEval("window.open('" + file + ".svgz', '_self')");
	}
}

/************
**  SVG図面情報取得
************/
function getsvgInfo() {
	var headG = svgG.childNodes;
	var infoG;
	for (var i = 0; i < headG.length; i++) {
		if (headG.item(i).nodeName == "z:info") {
			infoG = headG.item(i).childNodes;
			for (var j = 0; j < infoG.length; j++) {
				if (infoG.item(j).nodeName.indexOf("z:") != -1 ) {
					zinfo[infoG.item(j).nodeName] = infoG.item(j).firstChild.nodeValue;
				}
			}
			break;
		}
	}
}

/************
**  PDF図面情報取得表示
************/
function getpdfInfo() {
	var s = zinfo["z:comment"].toLowerCase().split(";")[0];
	if (s.indexOf("pdf=") != -1) {
		s = s.split("=")[1];
		if (detPCB) {
			if (reversed) {
				s = s.split(".")[0] + "_s." + s.split(".")[1];
			} else {
				s = s.split(".")[0] + "_f." + s.split(".")[1];
			}
		}
	} else {
		s = "";
	}
	return s;
}

/************
**  PDF図面表示
************/
function viewPdf(pdffile) {
	browserEval("window.open('pdf/" + pdffile + "', 'PDF', 'scrollbars=no,resizable=no,menubar=no,directories=no,status=no,location=no', '_blank')");
}

/************
**  図面情報表示
************/
function aboutDrawingInfo() {
	var info = '';
	info += _a0251 + zinfo["z:manualid"] + '\n';
	info += _a0252 + zinfo["z:manualtitle"] + '\n';
	info += _a0253 + zinfo["z:blockid"] + '\n';
	info += _a0254 + zinfo["z:drawingtitle"] + '\n';
	info += _a0255 + zinfo["z:version"] + '\n';
	info += _a0256 + zinfo["z:timestamp"] + '\n';
	if (zinfo["z:scriptenable"] == 1) {
		info += _a0257 + 'True';
	} else {
		info += _a0257 + 'False';
	}
	alert(info);
}

/************
**  ViewBox 読み取り
************/
function readViewBox() {
	var s;
	s = document.firstChild.getAttribute('viewBox');
	viewBox = s.split(' ');
}

/************
**  デフォルトコンテキストメニュー設定
************/
function defaultload(evt) {
//	// Retrieve the SVG document object:
//	var directTarget = evt.getTarget();
//	if (directTarget.getNodeType() != 9 ) {	// if not DOCUMENT_NODE
//		svgDocument = directTarget.getOwnerDocument();
//	} else {
//		svgDocument = directTarget; 
//	}
    var ver = getSVGViewerVersion();
	if (ver.indexOf("Adobe") != -1) {
		xmlcontext = evt.target.ownerDocument;
		getURL("js/plname.js", callback_fn);
	}
}

function callback_fn(urlRequestStatus) {
	if (urlRequestStatus.success) {
		var parts_fname = urlRequestStatus.content.split("'")[1];
		getURL(parts_fname, callback);
	}
}

function callback(urlRequestStatus) {
	if (urlRequestStatus.success) {
		// Adobe SVG Viewer 6.0対応
		var ver = getSVGViewerVersion();
		if (ver.indexOf("Adobe") != -1) {
	    	xmlparts = parseXML(urlRequestStatus.content);		// 改行、タブがない1行整形の方がDOMアクセスが早い！
		}
		var nodelist = xmlparts.getElementsByTagName("MODEL");
		for (var i = 0; i < nodelist.length; i++) {
			if (modelid == "") {
				models.push(nodelist.item(i).firstChild.nodeValue);
			} else {
				if (nodelist.item(i).getAttribute("MDL") == modelid) {
					models.push(nodelist.item(i).firstChild.nodeValue);
				}
			}
		}
		menuSet();
		copyLocationMenuUpdate('', '', '', '');
		favoriteMenuUpdate('', '', '', '');
		if (searchref != '') {
			selectOver(searchref);
			//focusBBox(select(searchref));
			select(searchref, true);
		}
		//if (reversed) {
		//	UpdateMenu('ReversedView', 'checked', null, false);
		//}
		if (embeded) {
			var file = selfsvg.split(".")[0];		// 拡張子削除
			var s = ""
			s += "if (self.parent.toc != null) {";
			s += "	self.parent.toc.chgtitle();";
			s += "}";
			browserEval(s);
		}
	}
}

/************
**  部品表選択表示
************/
function selectPlist(blk, ref) {
	if (embeded) {
		if (window.top) {	// for IE
			selectPlist2(blk, ref);
		} else {			// for Firefox
			browserEval("selectPlist2('" + blk + "','" + ref + "');");
		}
	}
}

/************
**  他方SVG内部品選択
************/
function syncsvg(blk, ref) {
	if (embeded) {
		if (window.top) {	// for IE
			syncsvg2(blk, ref);
		} else {			// for Firefox
			browserEval("syncsvg2('" + blk + "','" + ref + "');");
		}
	}
}

/************
**  ロケーションからパス名取得（ファイル名部のみ：拡張子含む）
************/
function getLocationSearch() {
	if (window.top) {	// for IE
		if (location.protocol.indexOf("file") != -1) {
			splitstr = "\\";
		} else {
			splitstr = "/";
		}
		selfsvg = location.pathname.split(splitstr);
		selfsvg = selfsvg[selfsvg.length - 1];
		if (selfsvg.split('.')[1].toLowerCase().indexOf('svg') == -1) {
			embeded = true;
		} else {
			embeded = false;
		}
		var l_search = location.search;
	} else { 			// for Firefox
		embeded = true;
		var url = document.URL.split("/");
		selfsvg = url[url.length - 1].split("?")[0];
		var l_search = "?" + url[url.length - 1].split("?")[1];
	}
	var qstr = new Array();
	if (l_search.length > 1) {
		var q_array = l_search.substr(1).split('&');
		for (id in q_array) {
	　　	qstr.push(q_array[id].split('='));
		}
		for (id in qstr) {
			switch (qstr[id][0].toLowerCase()) {
				case 'f': selfsvg 	= qstr[id][1]; break;
				case 'm': modelid 	= qstr[id][1].toUpperCase(); break;
				case 's': searchref = qstr[id][1].toUpperCase(); break;
				case 'v': favorite	= unescape(qstr[id][1]); break;
				case 'l': 
					if (qstr[id][1] == 'ja') {
						chgLang();
					}
					break;
			}
		}
	}
	if (window.top) {	// for IE Stand along
		if (self.navigator.userLanguage == 'ja') {
			chgLang();
		}
	}
}

/************
**  初期実行ルーチン
************/
//var svgDocument;
var selfsvg = '';
var searchref = '';
var favorite = '';
var modelid = '';
var embeded;
getLocationSearch();

var xmlparts;
//var parts_fname;

var reversed = false;
var layerMenuChecked = new Array();
var allLayerChecked = false;
var allLayerG = new Array();
var centerLayerNum;
var detPCB;
var rootG = document.getElementById('root');
var svgG = document.firstChild;
var selected = null;
var cache = new Array();
var cacheSide = new Array();
var cacheBBox = new Array();
var selectedOver = null;
var cacheOver = new Array();
var cacheSideOver = new Array();
//var cacheBBoxOver = new Array();
var viewBox;
//var animT = document.createElement('animate');
var autoZoomOut;

//animT.setAttribute('accumulate', 'none');
//animT.setAttribute('additive', 'replace');
//animT.setAttribute('calcMode', 'discrete');
//animT.setAttribute('fill', 'remove');
//animT.setAttribute('restart', 'always');
//animT.setAttribute('attributeName', 'opacity');
//animT.setAttribute('dur', '3s');
//animT.setAttribute('values', '1;0.25');
//animT.setAttribute('repeatCount', 'indefinite');

var zinfo = new Array();
zinfo["z:manualid"]		= "";
zinfo["z:manualtitle"]	= "";
zinfo["z:blockid"]		= "";
zinfo["z:drawingtitle"]	= "";
zinfo["z:version"]		= "";
zinfo["z:timestamp"]	= "";
zinfo["z:scriptenable"] = "";
zinfo["z:comment"] = "";

getsvgInfo();
var models = "";
models = new Array();

var crosslineG = document.createElement('g');
var crosslinePath = document.createElement('path');
var crosslineCircle = document.createElement('circle');
makeCrossLine();

setLayerClone();
readViewBox();

var ttG = document.createElement('g');
var ttRect = document.createElement('rect');
var ttRectS = document.createElement('rect');
var ttText = document.createElement('text');
var ttTextNode = document.createTextNode('test');
makeToolTip();

if (zinfo["z:scriptenable"] == 1) {
	rootG.addEventListener('click', click, false);
	rootG.addEventListener('mouseover', mouseover, false);
	rootG.addEventListener('mouseout', mouseout, false);
}
rootG.addEventListener('SVGLoad', defaultload, false);

//if (searchref != '') {
//	selectOver(searchref);
//	//focusBBox(select(searchref));
//	select(searchref, true);
//}
